/** @file   ObjectFactory.h
 * @brief   Declaration of ObjectFactory class.
 * @version $Revision: 1.3 $
 * @date    $Date: 2006/07/27 20:27:55 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_OBJECTFACTORY_H
#define H_WWW_OBJECTFACTORY_H
#include "SpawnEvent.h"

namespace WeWantWar {

/** @class  ObjectFactory
 * @brief
 * @author  Tomi Lamminsaari
 *
 */
class ObjectFactory
{
public:
  static GameObject* CreateGameObject( SpawnItem* aItem );

private:
  static GameObject* CreateAlien( SpawnItem* aItem );
  static GameObject* CreateCivilian( SpawnItem* aItem );
  static GameObject* CreateCar( SpawnItem* aItem );
  static GameObject* CreateSentryGun( SpawnItem* aItem );
  static GameObject* CreateFighter( SpawnItem* aItem );
  static GameObject* CreateDecorativeObject( SpawnItem* aItem );
  static GameObject* CreateBarrelObject( SpawnItem* aItem );
  static GameObject* CreateNpcCharacter( SpawnItem* aItem );
  static GameObject* CreateStarGate( SpawnItem* aItem );
};

};  // end of namespace

#endif
